package ru.yandex.stockpile.server.shard.merge;

import org.junit.Assert;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricsMatcher {
    private MetricsMatcher() {
    }

    public static void assertEqualTo(AggrGraphDataIterable expect, AggrGraphDataIterable actual) {
        assertEqualTo(expect.iterator(), actual.iterator());
    }

    public static void assertEqualTo(AggrGraphDataIterable expect, AggrGraphDataListIterator actual) {
        assertEqualTo(expect.iterator(), actual);
    }

    public static void assertEqualTo(AggrGraphDataListIterator expect, AggrGraphDataListIterator actual) {
        var expectedPoint = new AggrPoint();
        var actualPoint = new AggrPoint();

        int index = 0;
        while (expect.next(expectedPoint) && actual.next(actualPoint)) {
            Assert.assertEquals("index=" + (index++),expectedPoint, actualPoint);
        }

        if (expect.next(expectedPoint)) {
            Assert.assertEquals("index=" + (index + 1), expectedPoint, null);
        }

        if (actual.next(actualPoint)) {
            Assert.assertEquals("index=" + (index + 1), null, actualPoint);
        }
    }
}
