package ru.yandex.stockpile.server.shard.stat;

import java.util.concurrent.ThreadLocalRandom;

import org.junit.Test;

import ru.yandex.solomon.common.RequestProducer;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.stockpile.api.EProjectId;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
@SuppressWarnings("ProtocolBufferOrdinal")
public class UsageKeyTest {

    @Test
    public void key() {
        long key = UsageKey.key(
            EProjectId.SOLOMON.ordinal(),
            RequestProducer.SYSTEM.ordinal(),
            1,
            -42);
        assertEquals(EProjectId.SOLOMON.ordinal(), UsageKey.project(key));
        assertEquals(1, UsageKey.type(key));
        assertEquals(-42, UsageKey.shardId(key));
        assertEquals(RequestProducer.SYSTEM.ordinal(), UsageKey.producer(key));
    }

    @Test
    public void randomKey() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int index = 0; index < 10_000; index++) {
            int projectId = random(EProjectId.values()).ordinal() + r.nextInt(2);
            int kind = random(MetricType.values()).ordinal() + r.nextInt(2);
            int shardId = r.nextInt();
            int producer = random(RequestProducer.values()).ordinal() + r.nextInt(2);

            long key = UsageKey.key(projectId, producer, kind, shardId);
            assertEquals(projectId, UsageKey.project(key));
            assertEquals(kind, UsageKey.type(key));
            assertEquals(shardId, UsageKey.shardId(key));
            assertEquals(producer, UsageKey.producer(key));
        }
    }

    private <T> T random(T[] array) {
        var random = ThreadLocalRandom.current();
        int index = random.nextInt(array.length);
        return array[index];
    }
}
