package ru.yandex.stockpile.tool;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class SamplerTest {

    @Test
    public void limitPerSec() {
        Sampler sampler = new Sampler(1, 3);
        assertTrue(sampler.acquire());
        assertTrue(sampler.acquire());
        assertTrue(sampler.acquire());

        assertFalse(sampler.acquire());
    }

    @Test
    public void sample() {
        int total = 1000;
        Sampler sampler = new Sampler(0.3, total);
        int success = 0;
        int failed = 0;
        for (int index = 0; index < total; index++) {
            if (sampler.acquire()) {
                success++;
            } else {
                failed++;
            }
        }

        assertNotEquals(total, success);
        assertNotEquals(total, failed);
        assertEquals(0.3, (double) success / (double) total, 0.1);
        assertEquals(0.7, (double) failed / (double) total, 0.1);
    }
}
