#pragma once

#include <util/generic/map.h>
#include <util/generic/string.h>
#include <util/datetime/base.h>
#include <util/system/mutex.h>

namespace NSolomon {
    struct TUserMetricData {
        typedef TMap<TString, TString> TLabels;

        TUserMetricData()
            : Value(0.0)
            , Timestamp(0)
            , TTL(0)
            , Derived(false)
        {
        }

        TUserMetricData(double value, ui32 timestamp, ui32 ttl)
            : Value(value)
            , Timestamp(timestamp)
            , TTL(ttl)
            , Derived(false)
        {
        }

    public:
        double Value;
        ui32 Timestamp;
        ui32 TTL;
        TLabels Labels;
        bool Derived;
    };

    struct TUserMetrics {
        typedef TMap<TString, TUserMetricData> TMetricMap;
        typedef TMap<TString, TMetricMap> TServiceMap;

        void AddMetricData(const TString& serviceName, const TString& metricName, double value, size_t ttl,
                           const TString& modeName, const TString& valueOp,
                           const TUserMetricData::TLabels& extraLabels,
                           ui32 timestamp = TInstant::Now().TimeT());
        TString GetJsonRepresentation(const TString& serviceName = "default", bool format = false) const;
        TString GetMetricData(const TString& serviceName = "default") const;
        TString GetAndFlushMetricData(const TString& serviceName = "default");

    public:
        TServiceMap Services;

    private:
        TMutex Mutex;
    };

} //namespace NSolomon
