#pragma once

#include <solomon/tools/data-comparison/lib/actors/actors.h>
#include <solomon/tools/data-comparison/lib/util/options.h>
#include <solomon/tools/data-comparison/lib/monitor/monitor.h>

#include <library/cpp/monlib/metrics/labels.h>

#include <util/stream/file.h>

#include <functional>
#include <memory>

using TDcFilter = TOptions;

struct TMetricMeta {
    explicit TMetricMeta(NMonitoring::TLabels labels, TStockpileIds id, TStringBuf name)
            : Labels(std::move(labels))
            , Id(id)
            , Name(name)
    {
    }

    NMonitoring::TLabels Labels;
    TStockpileIds Id;
    TString Name;
};

inline TMetricMeta* MetricMetaCast(std::any& m) {
    try {
        return &(std::any_cast<TMetricMeta&>(m));
    } catch (...) {
        return nullptr;
    }
}


class IComparisonResolveDcConsumer: public IResolveDcConsumer {
public:
    using TFunc = std::function<void(TActorMetaData&& meta)>;

    virtual size_t Processed() const = 0;
    virtual size_t Errors() const = 0;
    virtual size_t Dropped() const = 0;

    void SetCallback(TFunc callback) {
        Callback_ = std::move(callback);
    }

protected:
    TFunc Callback_;
};

class IComparisonReadMetricsMetaConsumer: public IReadMetricsMetaConsumer {
public:
    using TFunc = std::function<void(TActorMetaData&& meta)>;

    void SetCallback(TFunc callback) {
        Callback_ = std::move(callback);
    }

    virtual size_t Processed() const = 0;
    virtual size_t Errors() const = 0;
    virtual size_t Dropped() const = 0;

protected:
    TFunc Callback_;
};

class IComparisonDownloadMetricsConsumer: public IDownloadMetricsConsumer {
public:
    using TFunc = std::function<void(TSeriesAndId&&, TActorMetaData&& meta)>;

    void SetCallback(TFunc callback) {
        Callback_ = std::move(callback);
    }

    virtual size_t Processed() const = 0;
    virtual size_t Errors() const = 0;
    virtual size_t Dropped() const = 0;

protected:
    TFunc Callback_;
};

using IComparisonResolveDcConsumerPtr = std::shared_ptr<IComparisonResolveDcConsumer>;
using IComparisonReadMetricsMetaConsumerPtr = std::shared_ptr<IComparisonReadMetricsMetaConsumer>;
using IComparisonDownloadMetricsConsumerPtr = std::shared_ptr<IComparisonDownloadMetricsConsumer>;

IComparisonResolveDcConsumerPtr CreateComparisonResolveDcConsumer(
        TDcFilter filter,
        IProgressMonitorPtr monitor,
        IOutputStream& s,
        IOutputStream& tr);
IComparisonReadMetricsMetaConsumerPtr CreateComparisonReadMetricsMetaConsumer(
        IProgressMonitorPtr monitor,
        IOutputStream& s,
        IOutputStream& tr);
IComparisonDownloadMetricsConsumerPtr CreateComparisonDownloadMetricsConsumer(
        IProgressMonitorPtr monitor,
        IOutputStream& s,
        IOutputStream& tr);
