#include <solomon/tools/data-comparison/lib/resolver/resolver.h>

#include <algorithm>

int main(int argc, char* argv[]) {
    if (argc != 2) {
        Cerr << "usage: " << argv[0] << " yasm_configs_dir_path\n";
        return 0;
    }

    auto resolver = MakeGroupResolver(argv[1]);
    auto dump = resolver->Metagroups();

    for (auto& [metagroup, groups]: dump) {
        std::sort(groups.begin(), groups.end());
        for (const auto& group: groups) {
            Cout << metagroup << " " << group << "\n";
        }
    }

    return 0;
}
