#pragma once

#include <solomon/tools/data-comparison/lib/stockpile/stockpile_client.h>
#include <solomon/tools/data-comparison/lib/resolver/resolver.h>

#include <library/cpp/monlib/metrics/labels.h>

#include <util/thread/pool.h>
#include <util/thread/lfqueue.h>

#include <atomic>
#include <thread>
#include <functional>
#include <any>
#include <memory>

using TActorMetaData = std::any;

using IActorEnginePtr = std::shared_ptr<IThreadPool>;
IActorEnginePtr CreateActorEngine(size_t threads);

class IResolveDcConsumer {
public:
    virtual void OnResolveGroupDc(TDcResolveResult dc, TStringBuf group, TActorMetaData meta) = 0;

    virtual void OnResolveHostDc(TDcResolveResult dc, TStringBuf host, TActorMetaData meta) = 0;

    virtual void OnHostError(TString error, TStringBuf host, TActorMetaData meta) = 0;

    virtual void OnGroupError(TString error, TStringBuf group, TActorMetaData meta) = 0;

    virtual ~IResolveDcConsumer() = default;
};

class IResolveDcActor {
public:
    virtual void Close() = 0;

    virtual void ResolveHostDc(TString host, TActorMetaData meta) = 0;

    virtual void ResolveGroupDc(TString group, TActorMetaData meta) = 0;

    virtual ~IResolveDcActor() = default;
};

using IResolveDcActorPtr = THolder<IResolveDcActor>;
using THostResolverFactory = std::function<IHostResolverPtr()>;
using TGroupResolverFactory = std::function<IGroupResolverPtr()>;

IResolveDcActorPtr CreateResolveDcActor(IActorEnginePtr engine, IResolveDcConsumer& consumer, THostResolverFactory hFactory);
IResolveDcActorPtr CreateResolveDcActor(IActorEnginePtr engine, IResolveDcConsumer& consumer, TGroupResolverFactory gFactory);

IResolveDcActorPtr CreateResolveDcActor(
        IActorEnginePtr  engine,
        IResolveDcConsumer& consumer,
        THostResolverFactory hFactory,
        TGroupResolverFactory gFactory);

using TStockpileClientFactory = std::function<IStockpileClientPtr()>;

class IReadMetricsMetaConsumer {
public:
    virtual void OnMetricMeta(TStockpileIds id, TInstant lastUpdate, TActorMetaData meta) = 0;

    virtual void OnError(TString error, TStockpileIds id, TActorMetaData meta) = 0;

    virtual ~IReadMetricsMetaConsumer() = default;
};

class IReadMetricsMetaActor {
public:
    virtual void Close() = 0;

    virtual void ReadMetricMeta(TStockpileIds id, TActorMetaData meta) = 0;

    virtual ~IReadMetricsMetaActor() = default;
};

using IReadMetricsMetaActorPtr = THolder<IReadMetricsMetaActor>;

IReadMetricsMetaActorPtr CreateReadMetricsMetaActor(
        IActorEnginePtr engine,
        IReadMetricsMetaConsumer& consumer,
        TStockpileClientFactory factory);


class IDownloadMetricsConsumer {
public:
    virtual void OnMetric(TSeriesAndId series, TActorMetaData meta) = 0;

    virtual void OnError(TString error, TStockpileIds id, TActorMetaData meta) = 0;

    virtual ~IDownloadMetricsConsumer() = default;
};

class IDownloadMetricsActor {
public:
    virtual void Close() = 0;

    virtual void Download(TStockpileIds id, TActorMetaData meta) = 0;

    virtual ~IDownloadMetricsActor() = default;
};

using IDownloadMetricsActorPtr = THolder<IDownloadMetricsActor>;

IDownloadMetricsActorPtr CreateDownloadMetricsActor(
        IActorEnginePtr engine,
        IDownloadMetricsConsumer& consumer,
        TStockpileClientFactory factory,
        TInstant fromMillis,
        TInstant toMillis);
