#pragma once

#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/summary_snapshot.h>
#include <library/cpp/monlib/metrics/histogram_snapshot.h>
#include <library/cpp/monlib/metrics/log_histogram_snapshot.h>

#include <solomon/tools/data-comparison/lib/util/options.h>
#include <solomon/tools/data-comparison/lib/stockpile/stockpile_data.h>
#include <solomon/tools/data-comparison/lib/monitor/monitor.h>
#include <solomon/tools/data-comparison/lib/cluster/cluster.h>

#include <util/stream/file.h>
#include <util/thread/pool.h>

#include <type_traits>
#include <unordered_map>
#include <unordered_map>

class TMetricComparator {
public:
    virtual bool Equal(const NSolomon::NTs::NValue::TSummaryDouble& lhs, const NSolomon::NTs::NValue::TSummaryDouble& rhs) const;

    virtual bool Equal(const NSolomon::NTs::NValue::THistogram& lhs, const NSolomon::NTs::NValue::THistogram& rhs) const;

    virtual bool Equal(const NSolomon::NTs::NValue::TLogHistogram& lhs, const NSolomon::NTs::NValue::TLogHistogram& rhs) const;

    virtual ~TMetricComparator() = default;

private:
    static constexpr double DEFAULT_EPS = 1e-9;
};

struct TSeriesComparisonResult {
    struct TShardResult {
        ui64 TotalPoints{0};
        ui64 MissingPoints{0};
    };

    TShardResult Actual;
    TShardResult Expected;

    ui64 CommonPoints{0};
    ui64 EqualPoints{0};
};

struct ILinkMaker {
    virtual TString MakeLink(NMonitoring::TLabels labels, ECluster cluster) const = 0;

    virtual ~ILinkMaker() = default;
};

enum class ESeriesComparisonFlags {
    MISSING_POINTS,
    MISSING_POINTS_SUMMARY,
    VALUE_DIFFERENCE,
    VALUE_DIFFERENCE_SUMMARY,
};

enum class EShardComparisonFlags {
    MISSING_METRICS,
    SERIES_DIFF,
    TYPES_SUMMARY,
    STORAGE_LINK,
    TYPE_MISMATCH
};

struct TShardComparisonOptions {
    THolder<TMetricComparator> Comparator;
    THolder<ILinkMaker> LinkMaker;

    struct TItem {
        TString Name;
        ECluster Cluster;
    };

    TOptions ShardComparisonFlags;
    TOptions SeriesComparisonFlags;

    TItem Expected;
    TItem Actual;
};

class IShardComparisonSummary {
public:
    virtual void AddActual(const NMonitoring::TLabels& labels, TSeriesAndId&& series) = 0;

    virtual void AddExpected(const NMonitoring::TLabels& labels, TSeriesAndId&& series) = 0;

    virtual void AddLabels(const NMonitoring::TLabels& labels) = 0;

    virtual void Write(IOutputStream& stream) = 0;

    virtual ~IShardComparisonSummary() = default;
};

using IShardComparisonSummaryPtr = THolder<IShardComparisonSummary>;
using IEnginePtr = std::shared_ptr<IThreadPool>;

IShardComparisonSummaryPtr CreateShardComparisonSummary(
        TShardComparisonOptions opts,
        IEnginePtr engine);
