#pragma once

#include <util/generic/string.h>

#include <memory>

class IProgressMonitor {
public:
    virtual void Start() = 0;

    virtual void IncTotal(size_t delta) = 0;
    virtual void IncProgress(size_t delta) = 0;

    virtual std::shared_ptr<IProgressMonitor> Share() = 0;

    virtual ~IProgressMonitor() = default;
};

using IProgressMonitorPtr = std::shared_ptr<IProgressMonitor>;
IProgressMonitorPtr CreateProgressMonitor(TStringBuf body);
