#pragma once

#include <solomon/libs/cpp/dns/dns.h>
#include <solomon/services/fetcher/lib/racktables/dc_matcher.h>

#include <unordered_map>
#include <string>
#include <vector>

enum class EDcResolveStatus {
    OK = 0,
    NOT_FOUND,
    TIMEOUT,
    UNKNOWN,
};

struct TDcResolveResult {
    NSolomon::EDc Dc{NSolomon::EDc::UNKNOWN};
    EDcResolveStatus Status{EDcResolveStatus::UNKNOWN};
};

class IHostResolver: public TThrRefBase {
public:
    virtual NThreading::TFuture<TIpv6AddressesSet> ResolveIp(const TString& host) = 0;
    virtual NThreading::TFuture<TDcResolveResult> ResolveDc(const TString& host) = 0;

    virtual ~IHostResolver() = default;
};

class IGroupResolver: public TThrRefBase {
public:
    virtual TString ResolveMetagroup(TStringBuf group) = 0;
    virtual NSolomon::EDc ResolveDc(TStringBuf group) = 0;
    virtual std::unordered_map<std::string, std::vector<std::string>> Metagroups() const = 0;

    virtual ~IGroupResolver() = default;
};

using IHostResolverPtr = TIntrusivePtr<IHostResolver>;
IHostResolverPtr MakeHostResolver();

using IGroupResolverPtr = TIntrusivePtr<IGroupResolver>;
IGroupResolverPtr MakeGroupResolver(const TString& configsDir);

TString DcToStr(NSolomon::EDc dc);

NSolomon::EDc StrToDc(TStringBuf dcStr);
