#pragma once

#include "stockpile_data.h"

#include <solomon/tools/data-comparison/lib/cluster/cluster.h>

#include <library/cpp/threading/future/future.h>

#include <solomon/libs/cpp/timeseries/timeseries.h>

using TAsyncReadMetricsMetaResponse = NThreading::TFuture<TReadMetricsMetaResponseOrError>;
using TAsyncReadManyResponse = NThreading::TFuture<TReadManyResponseOrError>;
using TAsyncCompressedReadManyResponse = NThreading::TFuture<TCompressedReadManyResponseOrError>;

class IStockpileClient: public TThrRefBase {
public:
    virtual void Open(ECluster cluster, TDuration connectionTimeout) = 0;

    virtual TAsyncCompressedReadManyResponse CompressedReadMany(ui32 shardId, const TVector<ui64>& localIds, ui64 fromMillis, ui64 toMillis) = 0;

    virtual TAsyncReadMetricsMetaResponse ReadMetricsMeta(ui32 shardId, const TVector<ui64>& localIds) = 0;

    virtual void Close() = 0;
};

using IStockpileClientPtr = TIntrusivePtr<IStockpileClient>;

IStockpileClientPtr MakeStockpileClient();
