#pragma once

#include <library/cpp/monlib/metrics/metric_type.h>

#include <solomon/services/dataproxy/lib/timeseries/timeseries.h>

#include <solomon/libs/cpp/ts_codec/columns.h>
#include <solomon/libs/cpp/error_or/error_or.h>

#include <memory>

struct TStockpileIds {
    ui32 ShardId;
    ui64 LocalId;

    struct THash {
        ui64 operator()(TStockpileIds ids) const {
            return std::hash<ui64>()(ids.ShardId) ^ std::hash<ui64>()(ids.LocalId);
        }
    };

    struct TEq {
        bool operator()(TStockpileIds lhs, TStockpileIds rhs) const {
            return lhs.ShardId == rhs.ShardId && lhs.LocalId == rhs.LocalId;
        }
    };
};

using ITimeseriesPtr = std::unique_ptr<NSolomon::NDataProxy::ITimeSeries>;
using ITimeseries = NSolomon::NDataProxy::ITimeSeries;
struct TSeriesAndId {
    TStockpileIds Id;
    ITimeseriesPtr Series;
};

struct TLastUpdate {
    ui64 LocalId{0};
    TInstant LastTsMillis;
};

using TReadManyResponse = TVector<TSeriesAndId>;
using TCompressedReadManyResponse = TVector<TSeriesAndId>;
using TReadMetricsMetaResponse = TVector<TLastUpdate>;

using TReadManyResponseOrError = NSolomon::TErrorOr<TReadManyResponse, TString>;
using TCompressedReadManyResponseOrError = NSolomon::TErrorOr<TCompressedReadManyResponse, TString>;
using TReadMetricsMetaResponseOrError = NSolomon::TErrorOr<TVector<TLastUpdate>, TString>;
