#pragma once

#include <util/generic/yexception.h>
#include <util/system/types.h>

#include <type_traits>

class TOptions {
public:
    template <class T>
    void AddFlag(T flag) {
        static_assert(std::is_enum_v<T> || std::is_integral_v<T>);
        Y_ENSURE(static_cast<ui64>(flag) < MAX_FLAGS);
        FlagsMask_ |= static_cast<ui64>(1) << static_cast<ui64>(flag);
    }

    template <class T>
    bool ContainFlag(T flag) const {
        static_assert(std::is_enum_v<T> || std::is_integral_v<T>);
        Y_ENSURE(static_cast<ui64>(flag) < MAX_FLAGS);

        return FlagsMask_ & (static_cast<ui64>(1) << static_cast<ui64>(flag));
    }

    bool IsEmpty() const {
        return !FlagsMask_;
    }

private:
    static constexpr size_t MAX_FLAGS = 64;
    ui64 FlagsMask_{0};
};
