#pragma once

#include <library/cpp/threading/future/future.h>

#include <memory>

struct TWaitContext: TAtomicRefCount<TWaitContext> {
    TWaitContext() = default;

    ~TWaitContext() {
        Promise_.SetValue();
    }

    NThreading::TFuture<void> GetFuture() {
        return Promise_;
    }

private:
    NThreading::TPromise<void> Promise_{NThreading::NewPromise<void>()};
};

using TWaitContextPtr = TIntrusivePtr<TWaitContext>;

inline TWaitContextPtr MakeWaitContext() {
    return MakeIntrusive<TWaitContext>();
}
