package config

import (
	"a.yandex-team.ru/solomon/tools/discovery/internal/units"
)

type MainConfig struct {
	GRPCAddr               string              `json:"grpc_addr"`
	MyCluster              map[string][]string `json:"my_cluster"`
	ServiceAddr            string              `json:"service_addr"`
	DNSAddr                string              `json:"dns_addr"`
	DNSTTL                 units.Duration      `json:"dns_ttl"`
	ClientTimeout          units.Duration      `json:"client_timeout"`
	SafeChangeUpFraction   float64             `json:"safe_change_up_fraction"`
	SafeChangeUpCount      int                 `json:"safe_change_up_count"`
	SafeChangeDownFraction float64             `json:"safe_change_down_fraction"`
	SafeChangeDownCount    int                 `json:"safe_change_down_count"`
	GrowthIsAlwaysSafe     bool                `json:"growth_is_always_safe"`
	EmptyGroupIsOk         bool                `json:"empty_group_is_ok"`
	BestEffortUnroll       bool                `json:"best_effort_unroll"`
	LogFile                string              `json:"log_file"`
	LogFileSize            units.Size          `json:"log_file_size"`
	LogFileCount           uint                `json:"log_file_count"`
	VerboseLevel           int                 `json:"verbose_level"`
	CacheDumpFile          string              `json:"cache_dump_file"`
	CacheDumpFileCount     int                 `json:"cache_dump_file_count"`
	CacheDumpInterval      units.Duration      `json:"cache_dump_interval"`
	DataSaveDir            string              `json:"data_save_dir"`
	DataUpdateInterval     units.Duration      `json:"data_update_interval"`
	UseIPDC                bool                `json:"use_ipdc"`
	ConductorCacheConfig   CacheConfig         `json:"conductor_cache_config"`
	KubeCacheConfig        CacheConfig         `json:"kube_cache_config"`
	ResolverConfig         CacheConfig         `json:"resolver_config"`
	IPDCConfig             CacheConfig         `json:"ipdc_config"`
	KubeConfigs            []*KubeConfig       `json:"kube_configs"`
	EdsCacheConfig         CacheConfig         `json:"eds_cache_config"`
	ServiceData            *ServiceData        `json:"service_data"`
}

type CacheConfig struct {
	CacheGoodTime   units.Duration `json:"cache_good_time"`
	CacheBadTime    units.Duration `json:"cache_bad_time"`
	PrefetchTime    units.Duration `json:"prefetch_time"`
	CleanUpInterval units.Duration `json:"cleanup_interval"`
	RequestTimeout  units.Duration `json:"request_timeout"`
	CacheMaxSize    int            `json:"cache_max_size"`
	Workers         int            `json:"workers"`
	ServeStale      bool           `json:"serve_stale"`
}

type KubeConfig struct {
	DNSZone        string `json:"dns_zone"`
	ConfigFilePath string `json:"config_file_path"`
	ConfigFileData string `json:"config_file_data"`
	User           string `json:"user"`
	Cluster        string `json:"cluster"`
}

type ServiceData struct {
	Ports    map[string]map[string]int         `json:"ports"`    // { <service>: { <portName>: <portNumber>, ... }, ... }
	Services map[string]map[string]*SourceData `json:"services"` // { <env>: { <service>: <sourceData>, ... }, ... }
}

type SourceData struct {
	Ports     string                         `json:"ports"`     // ports reference
	Endpoints map[string]map[string][]string `json:"endpoints"` // { <dc>: { <src>: [ <srcData>, ... ], ... }, ... }
}
