package cmd

import (
	"a.yandex-team.ru/library/go/yandex/oauth"
	"context"
	"fmt"
	"github.com/spf13/cobra"
	flag "github.com/spf13/pflag"
	"time"
)

const (
	clientID       = "e397b846943844228aca41877a8b85d6"
	clientSecret   = "aa15736d8bc8492c8bfa0578d9892f3f"
	defaultTimeout = 20 * time.Second
)

type TokenKey struct{}

// Command is a wrapper for all subcommands
type Command struct {
	Use     string
	Short   string
	Run     func(ctx context.Context, args []string, flags *flag.FlagSet) error
	Timeout time.Duration
}

func (c *Command) timeout() time.Duration {
	if c.Timeout != time.Duration(0) {
		return c.Timeout
	}
	return defaultTimeout
}

func (c *Command) run(cmd *cobra.Command, args []string) error {
	ctx, cancel := context.WithTimeout(context.Background(), c.timeout())
	defer cancel()

	token, err := oauth.GetTokenBySSH(ctx, clientID, clientSecret)
	if err != nil {
		return fmt.Errorf("cannot get OAuth token by SSH: %v", err)
	}

	ctx = WithAuthToken(ctx, token)
	return c.Run(ctx, args, cmd.Flags())
}

type Flag func(*flag.FlagSet)

func (c *Command) Init(flags ...Flag) {
	cmd := &cobra.Command{
		Use:   c.Use,
		Short: c.Short,
		RunE:  c.run,
	}
	for _, flagModifier := range flags {
		flagModifier(cmd.Flags())
	}
	rootCmd.AddCommand(cmd)
}

func WithAuthToken(ctx context.Context, token string) context.Context {
	return context.WithValue(ctx, TokenKey{}, token)
}

func GetAuthToken(ctx context.Context) string {
	return ctx.Value(TokenKey{}).(string)
}
