package cmd

import (
	"a.yandex-team.ru/solomon/libs/go/abc"
	"a.yandex-team.ru/solomon/libs/go/staff"
	"context"
	"fmt"
	flag "github.com/spf13/pflag"
	"sort"
	"time"
)

func init() {
	whoCmd := &Command{
		Use:   "who",
		Short: "Prints who is on duty today",
		Run:   runNotifyCmd,
	}
	whoCmd.Init()
}

func runNotifyCmd(ctx context.Context, args []string, flags *flag.FlagSet) error {
	token := GetAuthToken(ctx)

	abcClient := abc.NewClient(token)
	staffClient := staff.NewClient(token)

	now := time.Now()
	shifts, err := abcClient.Shifts(ctx, abc.FilterAtDay(now))
	if err != nil {
		return err
	}

	sort.Slice(shifts, func(i, j int) bool {
		return shifts[i].Schedule.ID < shifts[j].Schedule.ID
	})

	for i, shift := range shifts {
		if i > 0 {
			fmt.Println()
		}
		fmt.Println(shift.Schedule.Name)

		person, err := staffClient.Person(ctx, shift.Duty(now).Login)
		if err != nil {
			return err
		}
		printPerson(person)
	}

	return nil
}

func printPerson(person *staff.Person) {
	fmt.Println("    name:", person.FullNameEn())
	fmt.Println("  e-mail:", person.WorkEmail)
	fmt.Println("   phone:", person.MainPhone())
	fmt.Printf("      tg: https://telegram.me/%s\n", person.Telegram())
}
