#include "storage.h"

#include <library/cpp/getopt/last_getopt.h>

#include <util/stream/file.h>
#include <util/string/strip.h>

namespace NSolomon {
namespace NIndexer {

struct TArgs {
    TString DbPath;
    TString MetricsFilename;
};

int CreateIndex(const TArgs& args) {
    auto storage = CreateMmsStorage(args.DbPath, EUsageMode::WRITE_ONLY);

    TFileInput file(args.MetricsFilename);
    TString line;
    ui32 count = 0;

    while (file.ReadLine(line) != 0) {
        TStringBuf key, value;
        TStringBuf(line).Split(' ', key, value);
        value = StripString(value);

        TMetricId id = FromString<TMetricId>(key);
        storage->Write(id, value);

        if (++count % 10000 == 0) {
            Cerr << "\33[2K\rprocessed " << count << " metrics";
        }
    }

    Cerr << "\ntotal number of metrics: " << count;
    Cerr << "\ncompacting... ";
    storage->Compact();
    Cerr << "done." << Endl;

    return 0;
}

int CmdCreate(int argc, const char* argv[]) {
    TArgs args;
    NLastGetopt::TOpts opts;

    opts.AddLongOption('d', "db", "database path to write to")
            .RequiredArgument("STR")
            .StoreResult(&args.DbPath)
            .Required();
    opts.AddLongOption('f', "file", "file with metrics")
            .RequiredArgument("STR")
            .StoreResult(&args.MetricsFilename)
            .Required();

    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    return CreateIndex(args);
}

} // namespace NIndexer
} // namespace NSolomon
