#include "storage.h"

#include <library/cpp/getopt/last_getopt.h>

#include <util/stream/file.h>

namespace NSolomon {
namespace NIndexer {

struct TArgs {
    TString DbPath;
    TString InputFilename;
};

int FindInIndex(const TArgs& args) {
    IInputStream* inputStream;
    THolder<TFileInput> fileInput;
    if (args.InputFilename == "-") {
        inputStream = &Cin;
    } else {
        fileInput.Reset(new TFileInput(args.InputFilename));
        inputStream = fileInput.Get();
    }

    auto storage = CreateMmsStorage(args.DbPath, EUsageMode::READ_ONLY);

    TString line;
    while (inputStream->ReadLine(line) != 0) {
        TMetricId id = FromString<TMetricId>(line);
        TMaybe<TString> value = storage->Read(id);
        if (value) {
            Cout << line << ' ' << *value << Endl;
        }
    }

    return 0;
}

int CmdFind(int argc, const char* argv[]) {
    TArgs args;
    NLastGetopt::TOpts opts;

    opts.AddLongOption('d', "db", "database path to read from")
            .RequiredArgument("STR")
            .StoreResult(&args.DbPath)
            .Required();
    opts.AddLongOption('f', "file", "file with metric ids")
            .RequiredArgument("STR")
            .StoreResult(&args.InputFilename)
            .Required();

    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    return FindInIndex(args);
}

} // namespace NIndexer
} // namespace NSolomon


