#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/generic/maybe.h>

namespace NSolomon::NIndexer {

int CmdCreate(int argc, const char* argv[]);
int CmdFind(int argc, const char* argv[]);
int CmdLoad(int argc, const char* argv[]);
int CmdServer(int argc, const char* argv[]);

int SafeMain(int argc, const char* argv[]) {
    TModChooser mc;
    mc.AddMode("create", CmdCreate, "create index");
    mc.AddMode("find", CmdFind, "find names with index");
    mc.AddMode("load", CmdLoad, "load metrics data from one ore many YDB tables");
    mc.AddMode("server", CmdServer, "start HTTP server to process search requests");
    return mc.Run(argc, argv);
}

} // namespace NSolomon::NIndexer

int main(int argc, const char* argv[]) {
    try {
        return NSolomon::NIndexer::SafeMain(argc, argv);
    } catch (...) {
        Cerr << "Uncaught exception: " << CurrentExceptionMessage() << Endl;
        return 1;
    }
}
