#include "metric_id.h"

#include <util/generic/strbuf.h>
#include <util/string/cast.h>
#include <util/stream/output.h>

template <>
NSolomon::NIndexer::TMetricId FromStringImpl<NSolomon::NIndexer::TMetricId>(const char* data, size_t len) {
    TStringBuf buf(data, len);

    TStringBuf shardIdStr, localIdStr;
    buf.Split('/', shardIdStr, localIdStr);

    ui16 shardId = FromString<ui16>(shardIdStr);
    ui64 localId = FromString<ui64>(localIdStr);

    return { shardId, localId };
}

template <>
void Out<NSolomon::NIndexer::TMetricId>(IOutputStream& out, const NSolomon::NIndexer::TMetricId& id) {
    out << id.ShardId << '/' << id.LocalId;
}
