#pragma once

#include <util/generic/fwd.h>
#include <util/digest/numeric.h>
#include <util/generic/typetraits.h>

namespace NSolomon::NIndexer {

struct TMetricId {
    ui16 ShardId;
    ui64 LocalId;
};

} // namespace NSolomon::NIndexer

Y_DECLARE_PODTYPE(NSolomon::NIndexer::TMetricId);

template <>
struct THash<NSolomon::NIndexer::TMetricId> {
    size_t operator()(const NSolomon::NIndexer::TMetricId& id) {
        return CombineHashes(ui64(id.ShardId), id.LocalId);
    }
};
