#pragma once

#include "metric_id.h"

#include <util/generic/fwd.h>

class IThreadPool;

namespace NSolomon {
namespace NIndexer {

enum class EUsageMode {
    WRITE_ONLY,
    READ_ONLY,
    READ_WRITE,
};

class IStorage {
public:
    virtual ~IStorage() = default;

    virtual bool Write(TMetricId id, TStringBuf value) = 0;
    virtual TMaybe<TString> Read(TMetricId id) const = 0;

    virtual void Compact(IThreadPool* = nullptr) {
    }
};

using IStoragePtr = THolder<IStorage>;

IStoragePtr CreateRocksDbStorage(TStringBuf dbPath, EUsageMode usagMode);

IStoragePtr CreateMmsStorage(TStringBuf dbPath, EUsageMode usagMode);

} // namespace NIndexer
} // namespace NSolomon
