#!/bin/sh -e

# Java Flight Recorder

SCRIPT_DIR="$(dirname $(readlink -f $0))"

if [ $# -lt 2 ]; then
    echo "Usage: $0 <service_name> <duration>"
    echo
    echo "Possible values for service_name:"
    echo "   * alerting"
    echo "   * coremon"
    echo "   * gateway"
    echo "   * stockpile"
    echo
    echo "Duration must be in form <number><unit>"
    echo "Possible units: s (seconds), m (minutes)"
    echo
    echo "Example:"
    echo "   $ $0 coremon 10s"
    exit 1
fi

APP="$1"
DURATION="$2"

PID=$(pgrep -u "user_${APP}" -f "${APP}")
JMV_PATH="$(ps -o cmd -p ${PID} | sed -En 's|^(([/a-z_0-9-]*)/bin/java).*|\2|p')"

PROFILE="${JMV_PATH}/lib/jfr/profile.jfc"

OUTPUT_DIR="${HOME}/jfr"
OUTPUT_FILE="${OUTPUT_DIR}/${APP}-$(date +%Y_%m_%d-%H_%M).jfr"

run_jcmd() {
    sudo -u "user_${APP}" -s /bin/bash -c "${JMV_PATH}/bin/jcmd ${PID} $@"
}

main() {
    mkdir -p ${OUTPUT_DIR}
    chmod 777 ${OUTPUT_DIR}

    run_jcmd "JFR.check verbose=true"
    run_jcmd "JFR.start duration=${DURATION} filename=${OUTPUT_FILE} settings=${PROFILE}"
}

main

