#pragma once

#include "s3_client.h"

#include <solomon/libs/cpp/kv/kv_client.h>

#include <library/cpp/getopt/last_getopt.h>
#include <library/cpp/getopt/small/modchooser.h>

class TCliCommandBase: public TMainClass {
protected:
    virtual void Options(NLastGetopt::TOpts* opts) = 0;
    virtual int Run(const NLastGetopt::TOptsParseResult& opts) = 0;

private:
    int operator()(const int argc, const char** argv) override final;

protected:
    std::shared_ptr<NSolomon::NKikimr::IKikimrRpc> Rpc_;
    std::unique_ptr<NSolomon::TKikimrKvClient> KvClient_;
};

class TCliCommandTablet: public TCliCommandBase {
protected:
    virtual void Options(NLastGetopt::TOpts *opts) override;
    virtual int RunOnTablet(ui64 tabletId, ui64 shardId, const NLastGetopt::TOptsParseResult& opts) = 0;

private:
    int Run(const NLastGetopt::TOptsParseResult& opts) override final;
};

class TCliS3CommandBase: public TMainClass {
protected:
    virtual void Options(NLastGetopt::TOpts* opts) = 0;
    virtual int Run(const NLastGetopt::TOptsParseResult& opts) = 0;

private:
    int operator()(const int argc, const char** argv) override final;

protected:
    THolder<IS3Client> S3Client_;
};

class TCliS3CommandTablet: public TCliCommandTablet {
protected:
    void Options(NLastGetopt::TOpts* opts) override = 0;
    virtual int RunS3OnTablet(ui64 tabletId, ui64 shardId, const NLastGetopt::TOptsParseResult& opts) = 0;

private:
    int RunOnTablet(ui64 tabletId, ui64 shardId, const NLastGetopt::TOptsParseResult& opts) override final;

protected:
    THolder<IS3Client> S3Client_;
};

template <typename T>
T WaitAndCheck(NSolomon::TAsyncKvResult<T> result) {
    auto valueOrErr = result.ExtractValueSync();
    if (valueOrErr.Success()) {
        return valueOrErr.Extract();
    }
    throw yexception() << valueOrErr.Error().Message();
}

inline void WaitAndCheck(NSolomon::TAsyncKvResult<void> result) {
    auto valueOrErr = result.ExtractValueSync();
    if (!valueOrErr.Success()) {
        throw yexception() << valueOrErr.Error().Message();
    }
}
