#include "cmd_base.h"

#include <util/generic/singleton.h>

namespace {

/**
 * Create KV tablets in Solomon Volume.
 */
class TCmdCreate: public TCliCommandBase {
private:
    void Options(NLastGetopt::TOpts* opts) override {
        opts->AddLongOption("path")
                .Help("path of solomon volume")
                .RequiredArgument("PATH")
                .Required();
        opts->AddLongOption("tablets")
                .Help("number of tablets to create")
                .RequiredArgument("NUM")
                .DefaultValue(4096)
                .Optional();
    }

    int Run(const NLastGetopt::TOptsParseResult& opts) override {
        TString path = opts.Get("path");
        ui64 tablets = opts.Get<ui64>("tablets");
        WaitAndCheck(KvClient_->CreateSolomonVolume(path, tablets));
        return 0;
    }
};

} // namespace

TMainClass* CmdCreate() {
    return Singleton<TCmdCreate>();
}
