#include "cmd_base.h"

#include <util/generic/singleton.h>

namespace {

/**
 * Drop all KV tablets from specified Solomon Volume.
 */
class TCmdDrop: public TCliCommandBase {
private:
    void Options(NLastGetopt::TOpts* opts) override {
        opts->AddLongOption("path")
                .Help("path of solomon volume")
                .RequiredArgument("PATH")
                .Required();
    }

    int Run(const NLastGetopt::TOptsParseResult& opts) override {
        TString path = opts.Get("path");
        WaitAndCheck(KvClient_->DropSolomonVolume(path));
        return 0;
    }
};

} // namespace

TMainClass* CmdDrop() {
    return Singleton<TCmdDrop>();
}
