#include "cmd_base.h"

#include <util/generic/singleton.h>

namespace {

/**
 * Move (rename) file on specific KV-tablet associated with Stockpile shard.
 */
class TCmdMv: public TCliCommandTablet {
private:
    void Options(NLastGetopt::TOpts* opts) override {
        TCliCommandTablet::Options(opts);
        opts->SetFreeArgsNum(2);
        opts->SetFreeArgTitle(0, "source", "name of the source file to rename");
        opts->SetFreeArgTitle(1, "target", "name of the target file");
    }

    int RunOnTablet(ui64 tabletId, ui64, const NLastGetopt::TOptsParseResult& opts) override {
        TVector<TString> freeArgs = opts.GetFreeArgs();
        TString source = freeArgs[0];
        TString target = freeArgs[1];

        WaitAndCheck(KvClient_->RenameFile(tabletId, source, target));
        return 0;
    }
};

} // namespace

TMainClass* CmdMv() {
    return Singleton<TCmdMv>();
}
