#include "cmd_base.h"

#include <util/generic/singleton.h>

namespace {

/**
 * Read file located on a specific KV-tablet associated with Stockpile shard.
 */
class TCmdRead: public TCliCommandTablet {
private:
    void Options(NLastGetopt::TOpts* opts) override {
        TCliCommandTablet::Options(opts);
        opts->SetFreeArgsNum(1);
        opts->SetFreeArgTitle(0, "filename", "name of the file to read from");
    }

    int RunOnTablet(ui64 tabletId, ui64, const NLastGetopt::TOptsParseResult& opts) override {
        TString filename = opts.GetFreeArgs()[0];
        ui32 readChunkSize = 16*1024*1024;

        for (ui32 offt = 0; true; offt += readChunkSize) {
            TString data = WaitAndCheck(KvClient_->ReadFile(tabletId, filename, offt, readChunkSize));
            Cout << data;
            if (data.size() < readChunkSize) {
                break;
            }
        }
        Cout << Flush;
        return 0;
    }
};

} // namespace

TMainClass* CmdRead() {
    return Singleton<TCmdRead>();
}
