#include "cmd_base.h"

#include <util/generic/singleton.h>

namespace {

/**
 * Removes a file from specific KV-tablet associated with Stockpile shard.
 */
class TCmdRm: public TCliCommandTablet {
private:
    void Options(NLastGetopt::TOpts* opts) override {
        TCliCommandTablet::Options(opts);
        opts->AddLongOption("remove-by-prefix", "use filename as prefix and remove all matching files")
                .NoArgument()
                .Optional();
        opts->SetFreeArgsNum(1);
        opts->SetFreeArgTitle(0, "filename", "name of the file to remove");
    }

    int RunOnTablet(ui64 tabletId, ui64, const NLastGetopt::TOptsParseResult& opts) override {
        TString filename = opts.GetFreeArgs()[0];
        bool removeByPrefix = opts.Has("remove-by-prefix");

        auto range = NSolomon::TKikimrKvRange{filename, true, filename, true};
        if (removeByPrefix) {
            range.Begin += " ";
            range.End += "~";
        }

        WaitAndCheck(KvClient_->RemoveFiles(tabletId, range));
        return 0;
    }
};

} // namespace

TMainClass* CmdRm() {
    return Singleton<TCmdRm>();
}
