#include "cmd_base.h"

#include <util/generic/singleton.h>

namespace {

/**
 * Removes a file from s3 storage.
 */
class TCmdS3Rm: public TCliS3CommandBase {
private:
    void Options(NLastGetopt::TOpts* opts) override {
        opts->SetFreeArgsNum(1, 128);
        opts->SetFreeArgTitle(0, "filename", "name of the file to remove");
        opts->AddLongOption("recursive")
                .Help("do recursive files removal")
                .NoArgument()
                .Optional();
        opts->AddLongOption("max-keys")
                .Help("maximum number of files to remove")
                .RequiredArgument("NUMBER")
                .DefaultValue("10000")
                .Optional();
    }

    int Run(const NLastGetopt::TOptsParseResult& opts) override {
        bool recursive  = opts.Has("recursive");
        ui64 maxKeys    = std::stoull(opts.Get("max-keys"));

        if (!recursive) {
            if (!S3Client_->Del(opts.GetFreeArgs())) {
                return 1;
            }
        }
        std::string prefix = opts.GetFreeArgs()[0];
        TVector<IS3Client::TFileInfo> files;
        TVector<TString> keys;

        if (!S3Client_->ListRecursive(files, prefix, maxKeys)) {
            return 1;
        }
        for (const IS3Client::TFileInfo &f: files) {
            keys.push_back(TString(f.Name));
        }
        if (!S3Client_->Del(keys)) {
            return 1;
        }

        return 0;
    }
};

} // namespace

TMainClass* CmdS3Rm() {
    return Singleton<TCmdS3Rm>();
}
