#pragma once

#include <util/stream/output.h>
#include <util/stream/input.h>
#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <util/generic/yexception.h>

#include <sstream>

struct TLZ4TypeError: public yexception {
};
struct TLZ4RuntimeError: public yexception {
};

class TLz4Compress: public IOutputStream {
public:
    TLz4Compress(IOutputStream *out, size_t blockSize = 1 << 15);
    TLz4Compress(std::stringstream *out, size_t blockSize = 1 << 15);
    ~TLz4Compress() override;

    void UseHC();
    void UseDefault();

private:
    void DoWrite(const void *buf, size_t len) override;
    void DoFlush() override;
    void DoFinish() override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};


class TLz4Decompress: public IInputStream {
public:
    TLz4Decompress(IInputStream *in);
    TLz4Decompress(std::stringstream *in);
    ~TLz4Decompress() override;

    TString ReadAll();
    size_t ReadAll(std::ostream &out);
private:
    size_t DoRead(void *buf, size_t len) override;
    size_t DoReadTo(TString &st, char ch) override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

