#include <library/cpp/getopt/modchooser.h>

#include <util/stream/output.h>
#include <util/generic/yexception.h>

TMainClass* CmdLs();
TMainClass* CmdRead();
TMainClass* CmdWrite();
TMainClass* CmdRm();
TMainClass* CmdMv();
TMainClass* CmdCreate();
TMainClass* CmdDrop();

TMainClass* CmdS3Ls();
TMainClass* CmdS3Read();
TMainClass* CmdS3Write();
TMainClass* CmdS3Rm();

TMainClass* Cmd3SDump();
TMainClass* Cmd3SRestore();

int main(int agrc, const char* argv[]) {
    TModChooser mod;

    mod.AddMode("ls", CmdLs(), "list KV-tablets or files on KV-tablet");
    mod.AddMode("read", CmdRead(), "read file from KV-tablet");
    mod.AddMode("write", CmdWrite(), "write file in KV-tablet");
    mod.AddMode("rm", CmdRm(), "remove file from KV-tablet");
    mod.AddMode("mv", CmdMv(), "move file on KV-tablet");
    mod.AddMode("create", CmdCreate(), "create KV-tablets in Solomon volume");
    mod.AddMode("drop", CmdDrop(), "drop all KV-tablets in Solomon volume");

    mod.AddMode("s3ls", CmdS3Ls(), "list files in associated backup");
    mod.AddMode("s3read", CmdS3Read(), "read file from associated backup");
    mod.AddMode("s3write", CmdS3Write(), "write file to associated backup");
    mod.AddMode("s3rm", CmdS3Rm(), "remove file from associated backup");

    mod.AddMode("s3dump", Cmd3SDump(), "dump tablet to associated backup");
    mod.AddMode("s3restore", Cmd3SRestore(), "restore tablet from associated backup");

    try {
        return mod.Run(agrc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return 1;
    }
}

