#pragma once

#include <util/datetime/base.h>

#include <iostream>
#include <sstream>
#include <unordered_map>

struct IS3Client {
public:
    static const constexpr i64 UNLIMITED = -1;

    struct TFileInfo {
        std::string Name;
        ui64        SizeBytes       = 0;
        TInstant    LastModified    = TInstant::Zero();

        friend IOutputStream &operator<<(IOutputStream &Out, const TFileInfo &fileInfo) {
            return Out
                    << "Name: "             << fileInfo.Name
                    << " Size: "            << fileInfo.SizeBytes
                    << " LastModified: "    << fileInfo.LastModified;
        }
    };

    struct TDirInfo
    {
        std::string Name;

        friend IOutputStream &operator<<(IOutputStream &Out, const TDirInfo &dirInfo) {
            return Out << "Name: " << dirInfo.Name;
        }
    };

    virtual ~IS3Client() {}
    virtual void SetDebug(bool debug) = 0;
    virtual bool List(TVector<TFileInfo> &files, TVector<TDirInfo> &dirs, const std::string &prefix = {}, i64 maxKeys = UNLIMITED) = 0;
    virtual bool ListRecursive(TVector<TFileInfo> &files, const std::string &prefix = {}, i64 maxKeys = UNLIMITED) = 0;
    virtual bool Head(const std::string &key, TFileInfo &file) = 0;
    virtual bool Put(const std::string &key, std::stringstream &ss) = 0;
    virtual bool Put(std::unordered_map<std::string, std::stringstream> &keyToStringStream, size_t &bytes, int retry = 0) = 0;
    virtual bool Put(const std::unordered_map<std::string, std::string> &keyToFilename, size_t &bytes, int retry = 0) = 0;
    virtual bool Get(const std::string &key, std::iostream *ios) = 0;
    virtual bool Get(std::unordered_map<std::string, std::iostream *> &keyToIOStream, size_t &bytes, int retry = 0) = 0;
    virtual bool Get(std::unordered_map<std::string, std::stringstream> &keyToStringStream, size_t &bytes, int retry = 0) = 0;
    virtual bool Get(const std::unordered_map<std::string, std::string> &keyToFilename, size_t &bytes, int retry = 0) = 0;
    virtual bool Del(const TVector<TString> &keys) = 0;
};

THolder<IS3Client>CreateS3Client(TString keyFile,
                                 TString endpoint,
                                 TString bucket,
                                 bool balancerBypass = false,
                                 bool verbose = true);


