package ru.yandex.solomon.tool;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;

import com.google.common.net.HostAndPort;

import ru.yandex.kikimr.client.KikimrGrpcTransport;
import ru.yandex.kikimr.client.KikimrTransport;
import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.client.kv.KikimrKvClientImpl;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.solomon.tool.cfg.SolomonPorts;
import ru.yandex.solomon.util.NettyUtils;


/**
 * @author Sergey Polovko
 */
public final class KikimrHelper {

    private KikimrHelper() {
    }

    public static KikimrKvClient createKvClient(String host) {
        KikimrTransport transport = createTransport(host);
        return new KikimrKvClientImpl(transport);
    }

    public static KikimrKvClient createKvClient(List<HostAndPort> hosts) {
        KikimrTransport transport = createTransport(hosts);
        return new KikimrKvClientImpl(transport);
    }

    public static KikimrKvClient createKvClient(SolomonCluster cluster) {
        System.err.println("init Kikimr KV client...");
        KikimrTransport transport = createTransport(cluster);
        return new KikimrKvClientImpl(transport);
    }

    public static KikimrTransport createTransport(SolomonCluster cluster) {
        return createTransport(cluster.addressesKikimrGrpc());
    }

    public static KikimrTransport createTransport(String host) {
        return createTransport(Collections.singletonList(HostAndPort.fromParts(host, SolomonPorts.KIKIMR_GRPC)));
    }

    private static KikimrTransport createTransport(List<HostAndPort> hostAndPorts) {
        return new KikimrGrpcTransport(
            hostAndPorts,
            26 << 20,
            Duration.ofSeconds(5),
            Duration.ofSeconds(60),
            NettyUtils.createEventLoopGroup("io", Runtime.getRuntime().availableProcessors()),
            Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }
}
