package ru.yandex.solomon.tool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;

import com.google.common.net.HostAndPort;

import ru.yandex.grpc.utils.DefaultClientOptions;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.solomon.tool.cfg.SolomonPorts;
import ru.yandex.stockpile.client.StockpileClient;
import ru.yandex.stockpile.client.StockpileClientOptions;
import ru.yandex.stockpile.client.StockpileClients;
import ru.yandex.stockpile.client.StopStrategies;


/**
 * @author Sergey Polovko
 */
public class StockpileHelper {

    public static StockpileClient createGrpcClient(SolomonCluster cluster) {
        return createGrpcClient(cluster, ForkJoinPool.commonPool());
    }

    public static StockpileClient createGrpcClient(SolomonCluster cluster, ExecutorService executor) {
        var opts = StockpileClientOptions.newBuilder(
                DefaultClientOptions.newBuilder()
                    .setMaxOutboundMessageSizeInBytes(256 << 20) // 256 MiB
                    .setMaxInboundMessageSizeInBytes(256 << 20) // 256 MiB
                    .setRpcExecutor(executor)
                    .setResponseHandlerExecutorService(executor))
            .setRetryStopStrategy(StopStrategies.stopAfterAttempt(5))
            .build();

        return createGrpcClient(cluster, opts);
    }

    public static StockpileClient createGrpcClient(SolomonCluster cluster, StockpileClientOptions opts) {
        var hosts = cluster.hosts().stream()
            .map(host -> HostAndPort.fromParts(host, SolomonPorts.STOCKPILE_GRPC))
            .collect(Collectors.toList());

        return StockpileClients.create(hosts, opts);
    }
}
