package ru.yandex.solomon.tool.alerting.canonTests;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.zip.GZIPOutputStream;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.rpc.grpc.GrpcSchemeRpc;
import com.yandex.ydb.table.rpc.grpc.GrpcTableRpc;

import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.alert.api.converters.AlertConverter;
import ru.yandex.solomon.alert.dao.ydb.YdbSchemaVersion;
import ru.yandex.solomon.alert.dao.ydb.entity.YdbAlertsDao;
import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.protobuf.TAlert;
import ru.yandex.solomon.core.db.dao.ydb.YdbProjectsDao;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.solomon.util.PropertyInitializer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ExtractAlertsToFiles {

    static {
        PropertyInitializer.init();
    }

    static final String EXTRACTED_ALERTS = "/tmp/extracted.pb.gz";

    private static final SolomonCluster CLUSTER = SolomonCluster.PROD_FRONT;

    public static void main(String[] args) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        var root = CLUSTER.kikimrRootPath();
        var transport = GrpcTransport.forHosts(CLUSTER.addressesKikimrGrpc()).build();
        var table = TableClient.newClient(GrpcTableRpc.useTransport(transport))
                .sessionPoolSize(50, 200)
                .build();
        SchemeClient schema = SchemeClient.newClient(GrpcSchemeRpc.useTransport(transport)).build();
        YdbAlertsDao alertsDao = new YdbAlertsDao(root, table, schema, YdbSchemaVersion.MIN, mapper);
        YdbProjectsDao projectsDao = new YdbProjectsDao(table, root + "/Config/V2/Project", mapper, ForkJoinPool.commonPool());

        List<Project> projects = CompletableFutures.join(projectsDao.findAllNames());
        List<TAlert> alerts = new ArrayList<>();

        for (var project : projects) {
            String projectId = project.getId();

            var result = alertsDao.findAll(projectId).join();
            if (result.size() > 0) {
                System.out.println(projectId + " -> " + result.size());
            }

            for (Alert alert : result) {
                alerts.add(AlertConverter.alertToProto(alert));
            }
        }

        GZIPOutputStream os = new GZIPOutputStream(
                new FileOutputStream(EXTRACTED_ALERTS));
        for (var alert : alerts) {
            alert.writeDelimitedTo(os);
        }
        os.close();

        table.close();
        schema.close();
        System.exit(0);
    }

    private static void join(CountDownLatch latch) {
        try {
            latch.await();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}
