package ru.yandex.solomon.tool.cfg;

import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.rpc.grpc.GrpcTableRpc;

import ru.yandex.cloud.auth.token.TokenProvider;
import ru.yandex.cloud.token.IamTokenClientOptions;
import ru.yandex.cloud.token.Jwt;
import ru.yandex.cloud.token.grpc.GrpcIamTokenClient;
import ru.yandex.solomon.core.db.dao.ydb.YdbProjectsDao;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.tool.YdbHelper;

/**
 * @author Sergey Polovko
 */
public class ListProjects {

    static TokenProvider tokenProvider(String keyPath, String accountId, String keyId) {
        Path keyFilePath = Path.of(keyPath);

        var jwtBuilder = Jwt.newBuilder()
                .withAccountId(accountId)
                .withKeyId(keyId)
                .withPrivateKey(keyFilePath)
                .withTtl(Duration.ofHours(1));

        var tokenClient = new GrpcIamTokenClient(IamTokenClientOptions.forAddress("ts.private-api.cloud-preprod.yandex.net", 4282)
                .withHandlerExecutor(Executors.newSingleThreadExecutor())
                .withUserAgent("Solomon"));

        return TokenProvider.iam(tokenClient, jwtBuilder, Executors.newSingleThreadScheduledExecutor());
    }

    public static void main(String[] args) {
        var tokenProvider = tokenProvider("/Users/jamel/wp/iam.pem", "bfbku4ac1i90nqn3cokr", "bfbn3iqodem47j93bm6f");
        var ydbTransport = YdbHelper.createSecureRpcTransport("solomon-dn.ydb.cloud-preprod.yandex.net:2136", "/pre-prod_global/solomon", tokenProvider::getToken);
        var ydbClient = TableClient.newClient(GrpcTableRpc.ownTransport(ydbTransport))
                .build();

        var dao = new YdbProjectsDao(ydbClient, "/pre-prod_global/solomon/Config/V2/Project", new ObjectMapper(), ForkJoinPool.commonPool());

        List<Project> projects = dao.findAllNames().join();
        for (Project project : projects) {
            System.out.println(project.getId() + ' ' + project.getName());
        }

        System.exit(0);
    }
}
