package ru.yandex.solomon.tool.cleanup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.base.Strings;

/**
 * @author Vladimir Gordiychuk
 */
public class FilterProjects {
    private static final String LABEL_PRJ = "&prj=";

    public static void main(String[] args) {
        Path from = Path.of(args[0]);
        Path to = Path.of(args[1]);
        Set<String> filter = loadFilterSet(Path.of(args[2]));

        try (var reader = Files.newBufferedReader(from);
             var writer = Files.newBufferedWriter(to))
        {
            String line;
            while ((line = reader.readLine()) != null) {
                var prj = prj(line);
                if (Strings.isNullOrEmpty(prj)) {
                    continue;
                }

                if (filter.contains(prj)) {
                    writer.write(line);
                    writer.newLine();
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> loadFilterSet(Path path) {
        try (var stream = Files.lines(path)) {
            return stream.collect(Collectors.toSet());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String prj(String line) {
        int fromIdx = line.indexOf(LABEL_PRJ);
        if (fromIdx < 0) {
            return "";
        }

        fromIdx += LABEL_PRJ.length();

        int toIdx = line.indexOf("&", fromIdx);
        if (toIdx < 0) {
            return "";
        }

        return line.substring(fromIdx, toIdx);
    }
}
