package ru.yandex.solomon.tool.coremon;

import java.util.Optional;

import com.google.common.net.HostAndPort;

import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.monitoring.coremon.TCreateShardRequest;
import ru.yandex.monitoring.coremon.TShardAssignmentsRequest;
import ru.yandex.solomon.config.protobuf.rpc.TGrpcClientConfig;
import ru.yandex.solomon.config.thread.StubThreadPoolProvider;
import ru.yandex.solomon.coremon.client.grpc.CoremonHostClient;

/**
 * @author Sergey Polovko
 */
public class CoremonCli {

    private static final String DEFAULT_DOMAIN = ".search.yandex.net";

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: tool <host> <cmd> [additional args]");
            System.exit(1);
        }

        String host = args[0];
        String cmd = args[1];

        if (!host.endsWith(DEFAULT_DOMAIN)) {
            host += DEFAULT_DOMAIN;
        }

        ClientOptionsFactory factory = new ClientOptionsFactory(Optional.empty(), Optional.empty(), new StubThreadPoolProvider());
        var options = factory.newBuilder(
                        "",
                        TGrpcClientConfig.getDefaultInstance())
                .setClientId("coremon-cli")
                .build();
        var client = new CoremonHostClient(HostAndPort.fromParts(host, 4710), options);

        try {
            switch (cmd) {
                case "get_assignments":
                    getShardAssignments(client);
                    break;

                case "create_shard":
                    if (args.length < 5) {
                        System.err.println("Usage: tool <host> create_shard <project> <cluster> <service>");
                        System.exit(1);
                    }
                    String project = args[2];
                    String cluster = args[3];
                    String service = args[4];
                    createShard(client, project, cluster, service);
                    break;
            }
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }

        System.exit(0);
    }

    private static void getShardAssignments(CoremonHostClient client) {
        var request = TShardAssignmentsRequest.newBuilder()
            .setTtl(2)
            .build();

        var response = client.getShardAssignments(request).join();
        System.out.println(response);
    }

    private static void createShard(CoremonHostClient client, String project, String cluster, String service) {
        var request = TCreateShardRequest.newBuilder()
            .setTtl(2)
            .setProjectId(project)
            .setClusterName(cluster)
            .setServiceName(service)
            .build();

        var response = client.createShard(request).join();
        System.out.println(response);
    }
}
