package ru.yandex.solomon.tool.fetcher;

import java.util.Optional;

import ru.yandex.discovery.DiscoveryService;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.salmon.fetcher.proto.FetcherApiProto;
import ru.yandex.solomon.config.protobuf.DataSize;
import ru.yandex.solomon.config.protobuf.DataUnit;
import ru.yandex.solomon.config.protobuf.Time;
import ru.yandex.solomon.config.protobuf.TimeUnit;
import ru.yandex.solomon.config.protobuf.rpc.TGrpcClientConfig;
import ru.yandex.solomon.config.thread.StubThreadPoolProvider;
import ru.yandex.solomon.fetcher.client.FetcherClient;
import ru.yandex.solomon.fetcher.client.FetcherClientGrpc;
import ru.yandex.solomon.util.PropertyInitializer;


/**
 * @author Sergey Polovko
 */
public class GetShardsHealth {

    static {
        PropertyInitializer.init();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: tool <fqdn>");
            System.exit(1);
        }

        String address = args[0];

        DataSize maxMessageSize = DataSize.newBuilder()
            .setValue(10)
            .setUnit(DataUnit.MEGABYTES)
            .build();

        TGrpcClientConfig config = TGrpcClientConfig.newBuilder()
            .addAddresses(address + ":4720")
            .setThreadPoolName("CpuLowPriority")
            .setMaxInboundMessageSize(maxMessageSize)
            .setMaxOutboundMessageSize(maxMessageSize)
            .setConnectTimeout(Time.newBuilder().setValue(5).setUnit(TimeUnit.SECONDS))
            .setConnectTimeout(Time.newBuilder().setValue(25).setUnit(TimeUnit.SECONDS))
            .build();

        try (StubThreadPoolProvider threadPoolProvider = new StubThreadPoolProvider()) {
            ClientOptionsFactory factory = new ClientOptionsFactory(Optional.empty(), Optional.empty(), threadPoolProvider);
            FetcherClient fetcherClient = new FetcherClientGrpc(config, null, threadPoolProvider, DiscoveryService.async(), factory);
            FetcherApiProto.ShardsHealthResponse response = fetcherClient.getFetcherShardsHealths(address)
                .join();
            System.out.println(response);
        } catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }

        System.exit(0);
    }

}
