package ru.yandex.solomon.tool.stockpile;

import java.util.Arrays;

import ru.yandex.solomon.main.logger.LoggerConfigurationUtils;
import ru.yandex.solomon.util.ExceptionUtils;

/**
 * Usage
 * <pre>
 *     cd solomon-tools
 *     ya make
 *
 *     ./run.sh ru.yandex.solomon.tool.stockpile.StockpileBackup backup DEV_MYT 1
 *     ./run.sh ru.yandex.solomon.tool.stockpile.StockpileBackup ls DEV_MYT
 *     ./run.sh ru.yandex.solomon.tool.stockpile.StockpileBackup restore DEV_MYT b20180911T161530.
 *     ./run.sh ru.yandex.solomon.tool.stockpile.StockpileBackup rm DEV_MYT b20180911T161530.
 * </pre>
 *
 * @author Stepan Koltsov
 */
public class StockpileBackup {
    private static void printUsage() {
        StockpileBackupLs.printUsage();
        StockpileBackupRm.printUsage();
        StockpileBackupBackup.printUsage();
        StockpileBackupRestore.printUsage();
    }

    public static void main(String[] args) {
        LoggerConfigurationUtils.disableLogger();

        if (args.length < 1) {
            printUsage();
            System.exit(1);
        }

        try (StockpileBackupCommand backup = resolveCommand(args)) {
            backup.run();
        } catch (Throwable e) {
            ExceptionUtils.uncaughtException(e);
        }
        System.exit(0);
    }

    public static StockpileBackupCommand resolveCommand(String[] args) {
        String command = args[0];
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (command) {
            case "help":
                printUsage();
                System.exit(0);
            case "ls":
                return StockpileBackupLs.of(subArgs);
            case "backup":
                return StockpileBackupBackup.of(subArgs);
            case "restore":
                return StockpileBackupRestore.of(subArgs);
            case "rm":
                return StockpileBackupRm.of(subArgs);
            default:
                throw new RuntimeException("Unknown command: " + command);
        }
    }
}
