package ru.yandex.solomon.tool.stockpile;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.solomon.tool.stockpile.backup.BackupsHelper;

/**
 * @author Vladimir Gordiychuk
 */
public abstract class StockpileBackupCommand implements Runnable, AutoCloseable {
    protected final KikimrKvClient kikimrKvClient;
    @Autowired
    protected final StockpileToolCommon toolCommon;
    protected final BackupsHelper backupsHelper;

    public StockpileBackupCommand(SolomonCluster cluster) {
        this.kikimrKvClient = KikimrHelper.createKvClient(cluster);
        this.toolCommon = new StockpileToolCommon(kikimrKvClient);
        this.backupsHelper = new BackupsHelper(kikimrKvClient);
    }

    @Override
    public void close() {
        kikimrKvClient.close();
    }
}
