package ru.yandex.solomon.tool.stockpile;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.solomon.tool.stockpile.backup.BackupWithStats;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileBackupLs extends StockpileBackupCommand {
    private final String path;

    private StockpileBackupLs(SolomonCluster cluster, String path) {
        super(cluster);
        this.path = path;
    }

    public static StockpileBackupCommand of(String[] args) {
        if (args.length != 1) {
            printUsage();
            System.exit(1);
        }

        SolomonCluster cluster = SolomonCluster.valueOf(args[0]);
        return new StockpileBackupLs(cluster, cluster.getSolomonVolumePath());
    }

    @Override
    public void run() {
        long[] kvTablets = toolCommon.resolveKvTabletsForShards(path);

        LinkedHashMap<FileNamePrefix.Backup, List<BackupWithStats>> backupsByBackup = backupsHelper.listBackups(kvTablets);
        for (Map.Entry<FileNamePrefix.Backup, List<BackupWithStats>> e : backupsByBackup.entrySet()) {
            List<BackupWithStats> shardBackups = e.getValue();
            long diskSize = shardBackups.stream().mapToLong(BackupWithStats::getFilesSize).sum();
            System.out.println(e.getKey() + " " + shardBackups.size() + " " + diskSize);
        }

        System.out.println(backupsByBackup.size() + " backups total");
    }

    public static void printUsage() {
        System.err.println("Usage: tool ls <cluster_id>");
    }
}
