package ru.yandex.solomon.tool.stockpile;

import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileBackupRestore extends StockpileBackupCommand {
    private final FileNamePrefix.Backup backup;
    private final String path;

    private StockpileBackupRestore(SolomonCluster cluster, String path, FileNamePrefix.Backup backup) {
        super(cluster);
        this.path = path;
        this.backup = backup;
    }

    public static StockpileBackupCommand of(String[] args) {
        if (args.length != 2) {
            printUsage();
            System.exit(1);
        }

        SolomonCluster cluster = SolomonCluster.valueOf(args[0]);
        String path = cluster.getSolomonVolumePath();
        FileNamePrefix.Backup backup = FileNamePrefix.Backup.pf.parse(args[1]).get();
        return new StockpileBackupRestore(cluster, path, backup);
    }

    @Override
    public void run() {
        long[] tabletIds = toolCommon.resolveKvTabletsForShards(path);
        toolCommon.stockpileForEachShard(tabletIds, tabletId -> backupsHelper.restoreBackup(tabletId, backup));
        System.out.println("Restore done: " + backup);
    }

    public static void printUsage() {
        System.err.println("Usage: tool restore <cluster_id> <backup_prefix>");
    }
}
