package ru.yandex.solomon.tool.stockpile;

import ru.yandex.kikimr.client.kv.StringMicroUtils;
import ru.yandex.kikimr.util.NameRange;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileBackupRm extends StockpileBackupCommand {
    private final String path;
    private final FileNamePrefix.Backup backup;

    private StockpileBackupRm(SolomonCluster cluster, String path, FileNamePrefix.Backup backup) {
        super(cluster);
        this.path = path;
        this.backup = backup;
    }

    public static StockpileBackupCommand of(String[] args) {
        if (args.length != 2) {
            printUsage();
            System.exit(1);
        }

        SolomonCluster cluster = SolomonCluster.valueOf(args[0]);
        String path = cluster.getSolomonVolumePath();
        FileNamePrefix.Backup backup = FileNamePrefix.Backup.pf.parse(args[1]).get();
        return new StockpileBackupRm(cluster, path, backup);
    }

    @Override
    public void run() {
        System.out.println("create kv tablets...");
        long[] tabletIds = toolCommon.resolveKvTabletsForShards(path);
        System.out.println("create kv tablets done.");

        NameRange nameRange = StringMicroUtils.asciiPrefixToRange(backup.format());
        toolCommon.stockpileForEachShard(tabletIds,
            tabletId -> kikimrKvClient.deleteRange(tabletId, 0, nameRange, 0));
        System.out.println("done");
    }

    public static void printUsage() {
        System.err.println("Usage: tool rm <cluster_id> <path> <backup_prefix>");
    }
}
