package ru.yandex.solomon.tool.stockpile;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.client.kv.StringMicroUtils;
import ru.yandex.kikimr.util.NameRange;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.kikimrKv.KvTabletsMapping;
import ru.yandex.stockpile.server.data.names.FileNameParsed;
import ru.yandex.stockpile.server.data.names.LogAddressWithFileCount;
import ru.yandex.stockpile.server.data.names.StockpileKvNames;
import ru.yandex.stockpile.server.data.names.file.LogFile;


/**
 * @author Sergey Polovko
 */
public class StockpileCheckLogsAreComplete {

    private static SolomonCluster cluster = SolomonCluster.DEV_MYT;

    public static void main(String[] args) {
        KikimrKvClient kvClient = KikimrHelper.createKvClient(cluster);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        KvTabletsMapping kvMapping = new KvTabletsMapping("", kvClient, executor, executor);
        kvMapping.waitForReady();

        NameRange logsRange = StringMicroUtils.asciiPrefixToRange(StockpileKvNames.CURRENT_LOG_PREFIX);

        kvMapping.getShardIdStream().forEach(shardId -> {
            long tabletId = kvMapping.getTabletId(shardId);

            List<LogFile> logs = kvClient.readRangeNames(tabletId, 0, logsRange, 0).join()
                    .stream()
                    .map(f -> FileNameParsed.parseCurrent(f.getName()))
                    .filter(fp -> fp instanceof LogFile)
                    .map(fp -> (LogFile) fp)
                    .collect(Collectors.toList());

            try {
                LogAddressWithFileCount.fold(logs);
            } catch (Exception e) {
                System.err.println("shard " + shardId + " on " + tabletId + " FAILED");
            }
        });

        System.out.println("everything OK");
        System.exit(0);
    }

}
