package ru.yandex.solomon.tool.stockpile;

import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

import com.google.common.math.IntMath;
import org.junit.Assert;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.YdbClient;
import ru.yandex.solomon.tool.YdbHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.kikimrKv.KvTabletsMapping;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileCreateShards {
    public static void main(String[] args) {
        SolomonCluster cluster = SolomonCluster.valueOf(args[0]);
        String path = args[1];
        int count = Integer.parseInt(args[2]);
        if (IntMath.isPowerOfTwo(count)) {
            System.err.println("Shard count " + count + " is not power of two");
        }

        KikimrKvClient kv = KikimrHelper.createKvClient(cluster);
        YdbClient ydb = YdbHelper.createYdbClient(cluster);
        ydb.scheme.makeDirectories(Path.of(path).getParent().toString()).join().expect("created dirs");

        long[] ids = kv.resolveKvTablets(path).join();
        if (ids.length != 0) {
            System.err.println("Already created: " + ids.length);
            System.exit(1);
        }

        kv.createKvTablets(args[1], count).join();

        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        KvTabletsMapping kvMapping = new KvTabletsMapping(path, kv, executor, executor);
        kvMapping.waitForReady();
        executor.shutdown();

        assertEquals(count, kvMapping.getShardCount());
        for (int shardId = 1; shardId <= count; shardId++) {
            long tabletId = kvMapping.getTabletId(shardId);
            Assert.assertNotEquals(0, tabletId);
            Assert.assertTrue(kvMapping.hasTabletId(tabletId));
        }

        System.exit(0);
    }
}
