package ru.yandex.solomon.tool.stockpile;

import java.util.List;
import java.util.OptionalInt;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.client.kv.KikimrKvClientSync;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.client.shard.StockpileShardId;

/**
 * @author Stepan Koltsov
 */
public class StockpileLs implements AutoCloseable {

    private final KikimrKvClientSync kikimrKvClientSync;
    private final StockpileToolCommon toolCommon;

    public StockpileLs(SolomonCluster cluster) {
        KikimrKvClient kvClient = KikimrHelper.createKvClient(cluster);
        this.kikimrKvClientSync = new KikimrKvClientSync(kvClient);
        this.toolCommon = new StockpileToolCommon(kvClient);
    }

    void run(String path, StockpileShardId shardId) {
        long tabletId = toolCommon.resolveKvTabletsForShards(path)[shardId.getId() - 1];

        List<KikimrKvClient.KvEntryStats> entries = kikimrKvClientSync.readRangeNames(tabletId, 0);

        OptionalInt maxLength = entries.stream().mapToInt(e -> e.getName().length()).max();
        if (maxLength.isPresent()) {
            for (KikimrKvClient.KvEntryStats entry : entries) {
                System.out.println(StringUtils.rightPad(entry.getName(), maxLength.getAsInt()) + " " + entry.getSize());
            }
        }

        long totalSize = entries.stream().mapToLong(KikimrKvClient.KvEntryStats::getSize).sum();
        System.out.println(entries.size() + " files, " + totalSize + " bytes total");
    }

    @Override
    public void close() {
        kikimrKvClientSync.close();
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: tool <cluster> <shard>");
            System.exit(1);
        }

        SolomonCluster cluster = SolomonCluster.valueOf(args[0]);
        StockpileShardId shardId = StockpileShardId.parseObject(args[1]);

        try (StockpileLs tool = new StockpileLs(cluster)) {
            tool.run(cluster.getSolomonVolumePath(), shardId);
        }
    }
}
