package ru.yandex.solomon.tool.stockpile;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.client.kv.StringMicroUtils;
import ru.yandex.kikimr.util.NameRange;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.client.shard.StockpileShardId;
import ru.yandex.stockpile.kikimrKv.KvTabletsMapping;
import ru.yandex.stockpile.server.data.names.StockpileKvNames;

/**
 * @author Stepan Koltsov
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class StockpileRmPrefix {

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("usage: tool <clusterId> <shardId> <prefix>");
            System.exit(1);
        }

        SolomonCluster cluster = SolomonCluster.valueOf(args[0]);
        int shardId = StockpileShardId.parse(args[1]);
        String prefix = args[2];

        if (prefix.startsWith(StockpileKvNames.CURRENT_LOG_PREFIX)) {
            System.err.println("WARNING: deleting current logs, press ENTER to continue or Ctrl-C to abort");
            System.in.read();
        } else if (prefix.startsWith(StockpileKvNames.CURRENT_PREFIX)) {
            System.err.println("you are trying to delete current files, which is dangerous");
            System.exit(1);
        }

        try (KikimrKvClient kvClient = KikimrHelper.createKvClient(cluster)) {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            KvTabletsMapping kvMapping = new KvTabletsMapping(cluster.getSolomonVolumePath(), kvClient, scheduledExecutor, scheduledExecutor);
            kvMapping.waitForReady();

            long tabletId = kvMapping.getTabletId(shardId);

            System.err.println("deleting files: " + prefix + "*");
            NameRange nameRange = StringMicroUtils.asciiPrefixToRange(prefix);
            kvClient.deleteRanges(tabletId, 0, Collections.singletonList(nameRange), 0).join();

            // trigger shard reload
            System.err.println("incrementing tablet generation");
            kvClient.incrementGeneration(tabletId, 0).join();

            System.err.println("done");
            System.exit(0);
        }
    }
}
